//------------------------------------------------------------------------------
// File: FinalShowdown.cs
// Controls the final showdown between the hero, mad russian, and white and wong
// Author: Matthew Rudge
//------------------------------------------------------------------------------

$FinalShowdown::GateLeft  = 0;
$FinalShowdown::GateRight = 1;
$FinalShowdown::LogWhiteQuest    = "Wong Place, Wong Time";
$FinalShowdown::LogWongQuest     = "White Person for the Job";
$FinalShowdown::LogWhiteDesc     = "Cross the river, crack through Mr. White's defenses, and bring him to justice.";
$FinalShowdown::LogWongDesc      = "Cross the river, crack through Mr. Wong's defenses, and bring him to justice.";
$FinalShowdown::LogWhiteReward   = "Reward: End the threat to your settlements.";
$FinalShowdown::LogWongReward    = "Reward: End the threat to your settlements.";
$FinalShowdown::LogWhiteBrief[0] = "Capture Mr. Wong.";
$FinalShowdown::LogWongBrief[0]  = "Capture Mr. White.";
$FinalShowdown::LogWhiteBrief[1] = "Defeat the northern Bandit camp.";
$FinalShowdown::LogWongBrief[1]  = "Defeat the northern Bandit camp.";
$FinalShowdown::LogWhiteBrief[2] = "Defeat the southern Bandit camp.";
$FinalShowdown::LogWongBrief[2]  = "Defeat the southern Bandit camp.";
$FinalShowdown::LogWhiteLong[0]  = "Cross the river to capture the last of the troublemakers, Mr. Wong.";
$FinalShowdown::LogWongLong[0]   = "Cross the river to capture the last of the troublemakers, Mr. White.";
$FinalShowdown::LogWhiteLong[1]  = "Defeat the northern bandit camp to get the key to open the first gate.";
$FinalShowdown::LogWongLong[1]   = "Defeat the northern bandit camp to get the key to open the first gate.";
$FinalShowdown::LogWhiteLong[2]  = "Defeat the southern bandit camp to get the key to open the second gate.";
$FinalShowdown::LogWongLong[2]   = "Defeat the southern bandit camp to get the key to open the second gate.";

/******************************************************************************/
/** FINAL SHOWDOWN TASK HELPERS
/******************************************************************************/
////////////////////////////////////////////////////////////////////////////////
//! Activates final showdown tasks
////////////////////////////////////////////////////////////////////////////////
function startFinalShowdownTasks()
{
   tsStartTask("FinalShowdown", tsGetStartingVertexes("FinalShowdown"));
   GameCamera.flySpeed = 65;
   InitializeQuestGui();
   FinalDisastersMedium();
   
   watchtower1.playThread(0,"ambient");
   watchtower2.playThread(0,"ambient");
   
   // disable the quit scenario button
   $DisableQuitScenario = true;
}
////////////////////////////////////////////////////////////////////////////////
//! Deactivates final showdown tasks
////////////////////////////////////////////////////////////////////////////////
function endFinalShowDownTasks()
{
   GameCamera.flySpeed = 80;
   tsEndTask("FinalShowdown");
}
////////////////////////////////////////////////////////////////////////////////
//! Closes gates
//! \param %gate Gate object
//! \param %side right or left
////////////////////////////////////////////////////////////////////////////////
function closeGate(%gate, %side)
{
   if(!isObject(%gate)) {
      return;
   }
   
   if(%side == $FinalShowdown::GateLeft) {
      RemoveObject(%gate);
      %gate.rotateZ(-90);
      PlaceObject(%gate);
   }
   else if(%side == $FinalShowdown::GateRight) {
      RemoveObject(%gate);
      %gate.rotateZ(90);
      PlaceObject(%gate);
   }
}
////////////////////////////////////////////////////////////////////////////////
//! Opens gates
//! \param %gate Gate object
//! \param %side right or left
////////////////////////////////////////////////////////////////////////////////
function openGate(%gate, %side)
{
   if(!isObject(%gate)) {
      return;
   }
   
   if(%side == $FinalShowdown::GateLeft) {
      RemoveObject(%gate);
      %gate.rotateZ(90);
      PlaceObject(%gate);
   }
   else if(%side == $FinalShowdown::GateRight) {
      RemoveObject(%gate);
      %gate.rotateZ(-90);
      PlaceObject(%gate);
   }
}
////////////////////////////////////////////////////////////////////////////////
//! Returns coordinates of objects for final showdown
//! \param %objname Name of object to retrieve coords for
//! \retval string Position of object
////////////////////////////////////////////////////////////////////////////////
function finalShowdownGetCoords(%objname)
{
   // White chosen
   if(WhiteChosen.isComplete()) {
      switch$(%objname) {
         case "baseslinger1":
            return "-428 -362";
         case "baseslinger2":
            return "-164 -393";
         case "gate1bandit1":
            return "-328 -341";
         case "gate1bandit2":
            return "-335 -340";
         case "gate2bandit1":
            return "-234 -384";
         case "gate2bandit2":
            return "-241 -383";
         case "hideoutbandit1":
            return "-296 -443";
         case "hideoutbandit2":
            return "-302 -438";
         case "hideoutbandit3":
            return "-303 -430";
         case "hideoutbandit4":
            return "-298 -421";
      }
   }
   // Wong chosen
   else {
       switch$(%objname) {
         case "baseslinger1":
            return "-431 -344";
         case "baseslinger2":
            return "-162 -391";
         case "gate1bandit1":
            return "-185 -340";
         case "gate1bandit2":
            return "-201 -340";
         case "gate2bandit1":
            return "-318 -350";
         case "gate2bandit2":
            return "-329 -350";
         case "hideoutbandit1":
            return "-311 -442";
         case "hideoutbandit2":
            return "-315 -436";
         case "hideoutbandit3":
            return "-324 -429";
         case "hideoutbandit4":
            return "-332 -424";
      }
   }
}
////////////////////////////////////////////////////////////////////////////////
//! Adds final showdown quest to tracker dependent on white or wong reject
////////////////////////////////////////////////////////////////////////////////
function finalShowdownAddQuestToTracker()
{
   // White chosen
   if(WhiteChosen.isComplete()) {
      tsAddQuestToTracker(
         true, 
         $FinalShowdown::LogWhiteQuest, 
         "", 
         $FinalShowdown::LogWhiteDesc, 
         $FinalShowdown::LogWhiteReward
         );
      tsReadyQuest($FinalShowdown::LogWhiteQuest);
   }
   // Wong chosen
   else {
      tsAddQuestToTracker(
         true, 
         $FinalShowdown::LogWongQuest, 
         "", 
         $FinalShowdown::LogWongDesc, 
         $FinalShowdown::LogWongReward
         );
      tsReadyQuest($FinalShowdown::LogWongQuest);
   }
}
////////////////////////////////////////////////////////////////////////////////
//! Adds task to tracker dependent on white or wong reject
//! \param %task Task number
////////////////////////////////////////////////////////////////////////////////
function finalShowdownAddTaskToTracker(%task)
{
   // White chosen
   if(WhiteChosen.isComplete()) {
      tsAddTaskToTracker(
         $FinalShowdown::LogWhiteQuest,
         $FinalShowdown::LogWhiteBrief[%task],
         $FinalShowdown::LogWhiteLong[%task]
         );
   }
   // Wong chosen
   else {
      tsAddTaskToTracker(
         $FinalShowdown::LogWongQuest,
         $FinalShowdown::LogWongBrief[%task],
         $FinalShowdown::LogWongLong[%task]
         );
   }
}
////////////////////////////////////////////////////////////////////////////////
//! Completes task in tracker dependent on white or wong reject
//! \param %task Task number
////////////////////////////////////////////////////////////////////////////////
function finalShowdownCompleteTaskInTracker(%task)
{
    // White chosen
   if(WhiteChosen.isComplete()) {
      tsCompleteTaskInTracker(
         $FinalShowdown::LogWhiteQuest,
         $FinalShowdown::LogWhiteBrief[%task]
         );

   }
   // Wong chosen
   else {
      tsCompleteTaskInTracker(
         $FinalShowdown::LogWongQuest,
         $FinalShowdown::LogWongBrief[%task]
         );
   }
}




/******************************************************************************/
/** INTRO
/******************************************************************************/
////////////////////////////////////////////////////////////////////////////////
// Gives introductory dialog
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownIntro::onEnter(%this)
{
   Parent::onEnter(%this);
   
   // Intro dialog
   %dlg = "id_final_introone";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::More, getWhiteOrWongChoice());
   %dlg = "id_final_introtwo";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::More, "madrussian");
   %dlg = "id_final_FinalShowdownIntro";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::More, "HeroCharacter", %dlg);
   finalShowdownAddQuestToTracker();
   finalShowdownAddTaskToTracker(0);
}





/******************************************************************************/
/** GATE ONE NO KEY
/******************************************************************************/
////////////////////////////////////////////////////////////////////////////////
// Gives intro dialog when entering the gate one zone with no key
////////////////////////////////////////////////////////////////////////////////
function GateOneZoneNoKey::onExit(%this)
{
   Parent::onExit(%this);
   %dlg = "id_final_GateOneNoKeyIntroDialog";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::Okay, getWhiteOrWongChoice(), %dlg);
   tsEnableInput(false);
}
////////////////////////////////////////////////////////////////////////////////
// Pan to white or wong after intro dialog
////////////////////////////////////////////////////////////////////////////////
function GateOneNoKeyPanToWoW::onEnter(%this)
{
   Parent::onEnter(%this);
   
   // Stop white or wong from moving
   %wowAI = slgQueryInterface(getWhiteOrWongChoice(), $CID_AI);
   if(IsFollowingPath(%wowAI)) {
      StopMoving(%wowAI);
   }
   
   tsMoveCameraToObject(getWhiteOrWongChoice(), false);
}
function GateOneNoKeyPanToWoW::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("FinalShowdown", "GateOneNoKeyPanToWoW");
   }
}
////////////////////////////////////////////////////////////////////////////////
// Gives dialog about needing a key to open gate one
////////////////////////////////////////////////////////////////////////////////
function GateOneNoKeyWoWDialog::onEnter(%this)
{
   Parent::onEnter(%this);
   %dlg = "id_final_GateOneNoKeyWoWDialog";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::Okay, getWhiteOrWongChoice(), %dlg);
}
////////////////////////////////////////////////////////////////////////////////
// Pans to bandit camp one
////////////////////////////////////////////////////////////////////////////////
function NoKeyPanToBanditOne::onEnter(%this)
{
   Parent::onEnter(%this);
   tsMoveCameraToObject("banditbase1", false);
}
function NoKeyPanToBanditOne::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("FinalShowdown", "NoKeyPanToBanditOne");
   }
}
////////////////////////////////////////////////////////////////////////////////
// Dialog about bandit base one and finding key there
////////////////////////////////////////////////////////////////////////////////
function NoKeyBanditOneDlg::onEnter(%this)
{
   Parent::onEnter(%this);
   %dlg = "id_final_NoKeyBanditOneDlg";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::Okay, getWhiteOrWongChoice(), %dlg);
}
////////////////////////////////////////////////////////////////////////////////
// Pans back to White or Wong
////////////////////////////////////////////////////////////////////////////////
function NoKeyPanBackToWoW::onEnter(%this)
{
   Parent::onEnter(%this);
   tsMoveCameraToObject(getWhiteOrWongChoice(), false);
}
function NoKeyPanBackToWoW::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("FinalShowdown", "NoKeyPanBackToWoW");
   }
}
////////////////////////////////////////////////////////////////////////////////
// Gives White or Wong's closing dialog
////////////////////////////////////////////////////////////////////////////////
function NoKeyEndWoWDialog::onEnter(%this)
{
   Parent::onEnter(%this);
   %dlg = "id_final_NoKeyEndWoWDialog";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::Okay, getWhiteOrWongChoice(), %dlg);
}
////////////////////////////////////////////////////////////////////////////////
// Pans camera back to gate one zone
////////////////////////////////////////////////////////////////////////////////
function NoKeyPanBackToGateOneZone::onEnter(%this)
{
   Parent::onEnter(%this);
   tsMoveCameraToPosition(firstGateLeft.getPosition(), false);
}
function NoKeyPanBackToGateOneZone::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("FinalShowdown", "NoKeyPanBackToGateOneZone");
   }
}
////////////////////////////////////////////////////////////////////////////////
// End of no key
////////////////////////////////////////////////////////////////////////////////
function GateOneNoKeyEnd::onEnter(%this)
{
   Parent::onEnter(%this);
   tsEnableInput(true);
   tsCompleteVertexes("FinalShowdown", "GateOneNoKeyEnd");
   finalShowdownAddTaskToTracker(1);
}




/******************************************************************************/
/** GATE TWO NO KEY
/******************************************************************************/
////////////////////////////////////////////////////////////////////////////////
// Gives intro dialog when entering the gate two zone with no key
////////////////////////////////////////////////////////////////////////////////
function GateTwoNoKeyIntroDialog::onEnter(%this)
{
   Parent::onEnter(%this);
   %dlg = "id_final_GateTwoNoKeyIntroDialog";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::Okay, getWhiteOrWongChoice(), %dlg);
   tsEnableInput(false);
}
////////////////////////////////////////////////////////////////////////////////
// Pan to white or wong after intro dialog
////////////////////////////////////////////////////////////////////////////////
function GateTwoNoKeyPanToWoW::onEnter(%this)
{
   Parent::onEnter(%this);
   
   // Stop white or wong from moving
   %wowAI = slgQueryInterface(getWhiteOrWongChoice(), $CID_AI);
   if(IsFollowingPath(%wowAI)) {
      StopMoving(%wowAI);
   }
   
   tsMoveCameraToObject(getWhiteOrWongChoice(), false);
}
function GateTwoNoKeyPanToWoW::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("FinalShowdown", "GateTwoNoKeyPanToWoW");
   }
}
////////////////////////////////////////////////////////////////////////////////
// Gives dialog about needing a key to open gate two
////////////////////////////////////////////////////////////////////////////////
function GateTwoNoKeyWoWDialog::onEnter(%this)
{
   Parent::onEnter(%this);
   %dlg = "id_final_GateTwoNoKeyWoWDialog";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::Okay, getWhiteOrWongChoice(), %dlg);
}
////////////////////////////////////////////////////////////////////////////////
// Pans to bandit camp two
////////////////////////////////////////////////////////////////////////////////
function NoKeyPanToBanditTwo::onEnter(%this)
{
   Parent::onEnter(%this);
   tsMoveCameraToObject("banditbase2", false);
}
function NoKeyPanToBanditTwo::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("FinalShowdown", "NoKeyPanToBanditTwo");
   }
}
////////////////////////////////////////////////////////////////////////////////
// Dialog about bandit base two and finding key there
////////////////////////////////////////////////////////////////////////////////
function NoKeyBanditTwoDlg::onEnter(%this)
{
   Parent::onEnter(%this);
   %dlg = "id_final_NoKeyBanditTwoDlg";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::Okay, getWhiteOrWongChoice(), %dlg);
}
////////////////////////////////////////////////////////////////////////////////
// Pans camera back to gate one zone
////////////////////////////////////////////////////////////////////////////////
function NoKeyPanBackToGateTwoZone::onEnter(%this)
{
   Parent::onEnter(%this);
   tsMoveCameraToPosition(secondGateLeft.getPosition(), false);
}
function NoKeyPanBackToGateTwoZone::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("FinalShowdown", "NoKeyPanBackToGateTwoZone");
   }
}
////////////////////////////////////////////////////////////////////////////////
// End of no key
////////////////////////////////////////////////////////////////////////////////
function GateTwoNoKeyEnd::onEnter(%this)
{
   Parent::onEnter(%this);
   tsEnableInput(true);
   tsCompleteVertexes("FinalShowdown", "GateTwoNoKeyEnd");
   finalShowdownAddTaskToTracker(2);
}





/******************************************************************************/
/** BANDIT BASE ONE
/******************************************************************************/
////////////////////////////////////////////////////////////////////////////////
// Spawns the tough gunslinger once the base is destroyed
////////////////////////////////////////////////////////////////////////////////
function BanditBaseOneSpawnSlinger::onEnter(%this)
{
   Parent::onEnter(%this);
   %pos = finalShowdownGetCoords("baseslinger1");
   %obj = tsCreateObj("Toughgunslinger", "", $OST_NEUTRAL, %pos, "baseslinger1");
   %obj.setName("baseslinger1");
}
////////////////////////////////////////////////////////////////////////////////
// Pans to slinger after creation
////////////////////////////////////////////////////////////////////////////////
function BanditBaseOnePanToSlinger::onEnter(%this)
{
   Parent::onEnter(%this);
   tsEnableInput(false);
   tsMoveCameraToObject("baseslinger1", false);
}
function BanditBaseOnePanToSlinger::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("FinalShowdown", "BanditBaseOnePanToSlinger");
   }
}
////////////////////////////////////////////////////////////////////////////////
// Dialog from the gunslinger before fight
////////////////////////////////////////////////////////////////////////////////
function BanditBaseOneSlingerDialog::onEnter(%this)
{
   Parent::onEnter(%this);
   %dlg = "id_final_BanditBaseOneSlingerDialog";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::Okay, "baseslinger1", %dlg);
}
function BanditBaseOneSlingerDialog::onExit(%this)
{
   Parent::onExit(%this);
   tsEnableInput(true);
   tsConvertObjTeam("baseslinger1", $OST_BANDIT);
}
////////////////////////////////////////////////////////////////////////////////
// Dialog about the key after the gunslinger dies
////////////////////////////////////////////////////////////////////////////////
function BanditBaseOneKeyDialog::onEnter(%this)
{
   Parent::onEnter(%this);
   %dlg = "id_final_BanditBaseOneKeyDialog";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::Okay, "HeroCharacter", %dlg);
}
////////////////////////////////////////////////////////////////////////////////
// Activates vertex to open gate one door
////////////////////////////////////////////////////////////////////////////////
function BanditBaseOneCleanup::onEnter(%this)
{
   Parent::onEnter(%this);
   tsActivateVertexes("FinalShowdown", "GateOneWithKey");
   TaskModifier.strMarkVertex("FinalShowdown", "GateOneZoneNoKey", $TSV_CLOSED);
   tsCompleteVertexes("FinalShowdown", "BanditBaseOneCleanup");
   finalShowdownCompleteTaskInTracker(1);
}




/******************************************************************************/
/** BANDIT BASE TWO
/******************************************************************************/
////////////////////////////////////////////////////////////////////////////////
// Spawns the tough gunslinger once the base is destroyed
////////////////////////////////////////////////////////////////////////////////
function BanditBaseTwoSpawnSlinger::onEnter(%this)
{
   Parent::onEnter(%this);
   %pos = finalShowdownGetCoords("baseslinger2");
   %obj = tsCreateObj("Toughgunslinger", "", $OST_NEUTRAL, %pos, "baseslinger2");
   %obj.setName("baseslinger2");
}
////////////////////////////////////////////////////////////////////////////////
// Pans to slinger after creation
////////////////////////////////////////////////////////////////////////////////
function BanditBaseTwoPanToSlinger::onEnter(%this)
{
   Parent::onEnter(%this);
   tsEnableInput(false);
   tsMoveCameraToObject("baseslinger2", false);
}
function BanditBaseTwoPanToSlinger::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("FinalShowdown", "BanditBaseTwoPanToSlinger");
   }
}
////////////////////////////////////////////////////////////////////////////////
// Dialog from the gunslinger before fight
////////////////////////////////////////////////////////////////////////////////
function BanditBaseTwoSlingerDialog::onEnter(%this)
{
   Parent::onEnter(%this);
   %dlg = "id_final_BanditBaseTwoSlingerDialog";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::Okay, "baseslinger2", %dlg);
}
function BanditBaseTwoSlingerDialog::onExit(%this)
{
   Parent::onExit(%this);
   tsEnableInput(true);
   tsConvertObjTeam("baseslinger2", $OST_BANDIT);
}
////////////////////////////////////////////////////////////////////////////////
// Dialog about the key after the gunslinger dies
////////////////////////////////////////////////////////////////////////////////
function BanditBaseTwoKeyDialog::onEnter(%this)
{
   Parent::onEnter(%this);
   %dlg = "id_final_BanditBaseTwoKeyDialog";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::More, "HeroCharacter");
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", "id_finalBanditBaseTwoKeyDialogTwo", $TaskButton::Okay, "madrussian", %dlg);
}
////////////////////////////////////////////////////////////////////////////////
// Activates vertex to open gate two door
////////////////////////////////////////////////////////////////////////////////
function BanditBaseTwoCleanup::onEnter(%this)
{
   Parent::onEnter(%this);
   tsActivateVertexes("FinalShowdown", "GateTwoWithKey");
   TaskModifier.strMarkVertex("FinalShowdown", "GateTwoZoneNoKey", $TSV_CLOSED);
   tsCompleteVertexes("FinalShowdown", "BanditBaseTwoCleanup");
   finalShowdownCompleteTaskInTracker(2);
}


/******************************************************************************/
/** GATE ONE WITH KEY
/******************************************************************************/
////////////////////////////////////////////////////////////////////////////////
// Opens the doors after you have the key
////////////////////////////////////////////////////////////////////////////////
function GateOneOpenDoors::onEnter(%this)
{
   Parent::onEnter(%this);
   openGate(firstGateLeft, $FinalShowdown::GateLeft);
   openGate(firstGateRight, $FinalShowdown::GateRight);
   tsCompleteVertexes("FinalShowdown", "GateOneOpenDoors");
}




/******************************************************************************/
/** GATE TWO WITH KEY
/******************************************************************************/
////////////////////////////////////////////////////////////////////////////////
// Opens the doors after you have the key
////////////////////////////////////////////////////////////////////////////////
function GateTwoOpenDoors::onEnter(%this)
{
   Parent::onEnter(%this);
   openGate(secondGateLeft, $FinalShowdown::GateLeft);
   openGate(secondGateRight, $FinalShowdown::GateRight);
   tsCompleteVertexes("FinalShowdown", "GateTwoOpenDoors");
}





/******************************************************************************/
/** FINAL SHOWDOWN
/******************************************************************************/
////////////////////////////////////////////////////////////////////////////////
// Pans to white or wong you did not side with
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownPanToWoW::onEnter(%this)
{
   Parent::onEnter(%this);
   tsMoveCameraToObject(getWhiteOrWongReject(), false);
   tsEnableInput(false);
}
function FinalShowdownPanToWoW::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("FinalShowdown", "FinalShowdownPanToWoW");
   }
}
////////////////////////////////////////////////////////////////////////////////
// Dialog from white or wong you do not side with
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownWoWDlg::onEnter(%this)
{
   Parent::onEnter(%this);
   %dlg = "id_final_FinalShowdownWoWDlg";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::Okay, getWhiteOrWongReject(), %dlg);
   tsEnableInput(true);
}
////////////////////////////////////////////////////////////////////////////////
// White or wong reject leaves and disappears into town hall
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownWoWLeaves::onEnter(%this)
{
   Parent::onEnter(%this);
   tsMoveObjToTarget(getWhiteOrWongReject(), "hideout");
}
function FinalShowdownWoWLeaves::onUpdate(%this)
{
   %wow   = getWhiteOrWongReject();
   %cmpAI = slgQueryInterface(%wow, $CID_AI);
   if(!IsFollowingPath(%cmpAI)) {
      tsShowMesh(%wow, false);
      tsCompleteVertexes("FinalShowdown", "FinalShowdownWoWLeaves");
      %obj = tsCreateObj(%wow @ "data", %wow.name, $OST_NEUTRAL, %wow.getPosition(), %wow.getInternalName() @ "clone");
      %obj.setName(%wow @ "clone");
      %obj.showMesh(false);
   }
}
////////////////////////////////////////////////////////////////////////////////
// Spawns bandits after white or wong reject's dialog
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownSpawnBandits::onEnter(%this)
{
   Parent::onEnter(%this);
   
   // Spawn gate bandits
   %pos = finalShowdownGetCoords("gate1bandit1");
   %obj = tsCreateObj("Malebandit", "", $OST_BANDIT, %pos, "gate1bandit1");
   %obj.setName("gate1bandit1");
   %pos = finalShowdownGetCoords("gate1bandit2");
   %obj = tsCreateObj("Femalebandit", "", $OST_BANDIT, %pos, "gate1bandit2");
   %obj.setName("gate1bandit2");
   %pos = finalShowdownGetCoords("gate2bandit1");
   %obj = tsCreateObj("Malebandit", "", $OST_BANDIT, %pos, "gate2bandit1");
   %obj.setName("gate2bandit1");
   %pos = finalShowdownGetCoords("gate2bandit2");
   %obj = tsCreateObj("Femalebandit", "", $OST_BANDIT, %pos, "gate2bandit2");
   %obj.setName("gate2bandit2");
   
   // Spawn hide-out bandits
   %pos = finalShowdownGetCoords("hideoutbandit1");
   %obj = tsCreateObj("Malebandit", "", $OST_BANDIT, %pos, "hideoutbandit1");
   %obj.setName("hideoutbandit1");
   %pos = finalShowdownGetCoords("hideoutbandit2");
   %obj = tsCreateObj("Femalebandit", "", $OST_BANDIT, %pos, "hideoutbandit2");
   %obj.setName("hideoutbandit2");
   %pos = finalShowdownGetCoords("hideoutbandit3");
   %obj = tsCreateObj("Malebandit", "", $OST_BANDIT, %pos, "hideoutbandit3");
   %obj.setName("hideoutbandit3");
   %pos = finalShowdownGetCoords("hideoutbandit4");
   %obj = tsCreateObj("Femalebandit", "", $OST_BANDIT, %pos, "hideoutbandit4");
   %obj.setName("hideoutbandit4");
   
   // Complete vertexe
   tsCompleteVertexes("FinalShowdown", "FinalShowdownSpawnBandits");
}
////////////////////////////////////////////////////////////////////////////////
// Closes the gates after bandits are spawned (trap has sprung!)
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownCloseGates::onEnter(%this)
{
   Parent::onEnter(%this);
   
   // Close second gate
   //closeGate(secondGateLeft, $FinalShowdown::GateLeft);
   //closeGate(secondGateRight, $FinalShowdown::GateRight);
   
   // Close first gate
   //closeGate(firstGateLeft, $FinalShowdown::GateLeft);
   //closeGate(firstGateRight, $FinalShowdown::GateRight);
   
   // Complete vertex
   tsCompleteVertexes("FinalShowdown", "FinalShowdownCloseGates");
}
////////////////////////////////////////////////////////////////////////////////
// Reopens gate one after bandits have been killed around gate one
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownReopenGateOne::onExit(%this)
{
   Parent::onExit(%this);
   //openGate(firstGateLeft, $FinalShowdown::GateLeft);
   //openGate(firstGateRight, $FinalShowdown::GateRight);
}
////////////////////////////////////////////////////////////////////////////////
// Reopens gate two after bandits have been killed around gate two
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownReopenGateTwo::onExit(%this)
{
   Parent::onExit(%this);
   //openGate(secondGateLeft, $FinalShowdown::GateLeft);
   //openGate(secondGateRight, $FinalShowdown::GateRight);
}
////////////////////////////////////////////////////////////////////////////////
// Forces white or wong to reappear (hideout is destroyed)
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownWoWReappears::onExit(%this)
{
   Parent::onExit(%this);
   %wow = getWhiteOrWongReject() @ "clone";
   tsShowMesh(%wow, true);
   tsConvertObjTeam(%wow, $OST_BANDIT);   
}
////////////////////////////////////////////////////////////////////////////////
// Monitors when white or wong reject surrenders. Updates position of wong or
// white to clone
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownWoWSurrenders::onUpdate(%this)
{
   Parent::onUpdate(%this);
   
   // Set position of real white or wong
   %wow      = getWhiteOrWongReject();
   %wowclone = %wow @ "clone";
   if(isObject(%wowclone)) {
      %pos  = %wowclone.getPosition();
      %wow.setPosition(getWord(%pos, 0), getWord(%pos, 1));
      
      // Vertex done if true
      if(!(isObject(hideoutbandit1)
      || isObject(hideoutbandit2)
      || isObject(hideoutbandit3)
      || isObject(hideoutbandit4)
      || !%wowclone.isHealing)) {
        tsCompleteVertexes("FinalShowdown", "FinalShowdownWoWSurrenders");
      }
   }
}
////////////////////////////////////////////////////////////////////////////////
// Pans to white or wong reject on defeat
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownWoWSurrenderPan::onEnter(%this)
{
   Parent::onEnter(%this);
   
   %wow      = getWhiteOrWongReject();
   %wowclone = %wow @ "clone";
   tsShowMesh(%wowclone, false);
   tsShowMesh(%wow, true);
   %wowclone.DeleteObject();
  
   tsMoveCameraToObject(%wow, false);
   tsEnableInput(false);
}
function FinalShowdownWoWSurrenderPan::onUpdate(%this)
{
   Parent::onUpdate(%this);
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes("FinalShowdown", "FinalShowdownWoWSurrenderPan");
   }
}
////////////////////////////////////////////////////////////////////////////////
// Dialog on surrender
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownWoWSurrenderDlg::onEnter(%this)
{
   Parent::onEnter(%this);
   tsEnableInput(true);
   %dlg = "id_final_FinalShowdownWoWSurrenderDlg";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::More, getWhiteOrWongReject());
   %dlg = "id_final_FinalShowdownHeroWinDlg";
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg, $TaskButton::More, "HeroCharacter");
   %wow = getWhiteOrWongReject();   
   if(stricmp(%wow,"mrwong") == 0)
   {
      %dlg2 = "id_final_WinTwoWhiteDlg";
   }
   else
   {
      %dlg2 = "id_final_WinTwoWongDlg";
   }
   tsSendTaskPopUpDlg("ID_TASKNAME_SHOWDOWN", %dlg2, $TaskButton::Okay, "HeroCharacter", "ID_Westward2Endgame");
   
   finalShowdownCompleteTaskInTracker(0);
   
   TaskModifier.strMarkVertex("FinalShowdown", "CompleteFinalReturn", $TSV_AVAIL);
}
//***************************************************************
//* Returns to Campaign2 map
//***************************************************************
function CompleteFinalReturn::onExit(%vertex)
{
   // return from this satellite
   %scenario = new SLScenario()
   {
        stack = false;
   };
   LoadScenario(%scenario,"", winFinalTasks);
   
}
function winFinalTasks()
{
   // Award Pioneer Badge
   tsAwardBadge("badge_pioneer1");
   
   // complete the final satellite (note that only one of these
   // satellites is visible, so only one will be marked completed)
   mapsatellite_finalwhite.disabled = false;
   mapsatellite_finalwong.disabled = false;
   
   //Reward XP
   tsModifyResource($Resource::Experience, 100, true);
   SendProductionToClient(HeroCharacter, "100 experience");
   
   // Spawn Hero Villians
   %pos = herocharacter.getposition();   
   
   %wow = getWhiteOrWongChoice();   
   if(stricmp(%wow,"mrwong") == 0)
   {
      %obj1 = tsCreateObj("MrWongData", "mrwong", $OST_PLAYER, %pos, "mrwong");
      %obj1.name = "Mr.Wong ";
   }
   else
   {
      %obj1 = tsCreateObj("MrWhiteData", "mrwhite", $OST_PLAYER, %pos, "mrwhite");
      %obj1.name = "Mr.White ";
   }
   //Spawn MadRussian
   %obj2 = tsCreateObj("MadRussianData", "madrussian", $OST_PLAYER, %pos, "madrussian");
   %obj2.name = "Mad'Russian";
   
   TaskModifier.strMarkVertex("Campaign2Tasks", "WW2EndGameDelay", $TSV_AVAIL);
   
   //Quest log

}

//***************************************************************
//* Disasters
//***************************************************************

// add average disasters
function FinalDisastersMedium()
{
   
   %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 2 minutes, a disaster can occur
      addDisasterNode = "0 100 2";
      
      // frequency pool, respawning time
      disasterBanditRate = "100 100";
      disasterDroughtRate = "0 120";
      disasterEarthquakeRate = "0 150";
      disasterFamineRate = "0 150";
      disasterFireRate = "10 180";
      disasterPlagueRate = "0 150";
      disasterTornadoRate = "15 180";
      
      disasterStack = $DisasterStack::Push;
   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 100;
      duration = 1000;

      fadeTime = 1;
      goldMin = 0;
      goldMax = 100;
      goldLow = 5;
      goldHigh = 10;
      lowCount = 2;
      highCount = 3;

      happinessCount = -25;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
   
   // update the fire scenario
   %scenario.disasterFireScenario = new SLFireScenario()
   {
      chance = 15;
      duration = -1;
      
      startStrength = 2;
      
      spreadCount = 2;
      spreadTime = 15;
      spreadChance = 40;
      spreadRadius = 25;
      spreadStrength = 1;
      
      burnTime = 15;
      burnStrength = 1;
      burnMax = 4;      
      
      damageTime = 0.4;
      damageStrength = 1;
   };
   
   // update the tornado scenario
   %scenario.disasterTornadoScenario = new SLTornadoScenario()
   {
      object = "tornado";

      chance = 25;
      duration = 60;

      travelAngle = 35;
      travelRandom = 25;
      travelTimeLow = 3;
      travelTimeHigh = 6;
      travelSpeedLow = 3;
      travelSpeedHigh = 5;
      radius = 8;
      damage = 30;
   };
   
   LoadScenario(%scenario);
}

// End FinalShowdown.cs